﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Drawing;
using System.Windows.Forms;
using FDK;

namespace StrokeStyleT
{
	class CStage選曲 : CActivity
	{
		public CStage選曲()
		{
			this.list子Activities.Add( this.Actホワイトイン = new CMActフェードイン・透明度( 4 ) );
			this.list子Activities.Add( this.Act英数字描画 = new CAct英数字描画() );
			this.list子Activities.Add( this.Act曲リスト管理 = new CActユーザ別曲リスト管理() );
			this.list子Activities.Add( this.Actログインユーザ選択 = new CActユーザ選択() );
			this.list子Activities.Add( this.Act入力割当 = new CAct入力割当() );
			this.list子Activities.Add( this.Actコンフィグ = new CActコンフィグ() );
		}

		public void t選択曲を最初の曲にリセットする()
		{
			// Global.SongList が再構築された後に呼び出されることを想定している。
			// 本ステージが活性化してるか否かに関係無く呼び出されるので注意。

			this.list現在の曲リスト = Global.Song.list曲リスト;
			this.stackBOXの曲番号 = new Stack<int>();
			this.n現在の選択曲番号 = 0;	// ツリールートにおける選択曲の Song番号をstackに格納。
			this.n現在の中心曲番号 = 0;
			this.nカーソルY位置0to2 = 1;
		}
		public void t現在の中心曲を起点として曲番号マップを更新する()
		{
			// マップをクリア。

			for( int i = 0; i < 9 * 3; i++ )
				this.ar曲番号マップ[ ( i % 9 ), ( i / 9 ) ] = 0;


			// 曲がないならここで終わり。

			if( this.list現在の曲リスト.Count == 0 )
				return;


			// 中心曲番号を起点にマップを生成する。

			// △□□□□□□□△		-13 -10 -7 -4 -1 ２ ５ ８ 11	０が中心曲。（≠選択曲の場合あり）
			// △□□□□□□□△	→	-12  -9 -6 -3 ０ ３ ６ ９ 12	■が選択曲。（≠中心曲の場合あり）
			// △□□□■□□□△		-11  -8 -5 -2 １ ４ ７ 10 13	△は画面外。

			for( int i = 0; i < 9 * 3; i++ )
				this.ar曲番号マップ[ ( i / 3 ), ( i % 3 ) ] = this.t中心曲から指定された相対数だけ離れた曲番号を返す( i - 13 );
		}

		enum EフェーズID { 
			フェードイン, 
			通常,
			設定,
			曲リスト編集,
			ユーザ変更,
			キーアサイン変更
		}
		Cスレッドセーフ<EフェーズID> eフェーズID = new Cスレッドセーフ<EフェーズID>( EフェーズID.フェードイン );

		public override void On活性化()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してる )
				return;
			//-----------------
			#endregion

			this.eフェーズID.Set( EフェーズID.フェードイン );

			this.n目標のスクロールカウンタ = 0;
			this.n現在のスクロールカウンタ = 0;

			if( this.list現在の曲リスト == null )			// 曲リストや選択曲、中心曲などは、t選択曲を最初の曲にリセットする() を
				this.t選択曲を最初の曲にリセットする();		// 呼び出さない限り、ステージが変わっても維持され続ける。

			//this.FPS = new CFPS();	→ ここでは生成しない。測定開始時に生成する。
			//this.VPS = new CFPS();
			this.sdカーソル移動音 = Global.SoundDevice.tサウンドを作成する( Folder.stgテーマファイル( @"ScreenSelect cursor move.wav" ) );
			this.sd曲決定音 = Global.SoundDevice.tサウンドを作成する( Folder.stgテーマファイル( @"ScreenSelect decide.wav" ) );
			this.ms背景動画 = new CMediaSession();
			this.ms背景動画.t構築する( Global.App.hWindow, Folder.stgテーマファイル( @"ScreenSelect BGV.mp4" ), false, true );
			this.mスクロールアニメ用一定間隔処理 = new C一定間隔処理();

			base.On活性化();
		}
		public override void On非活性化()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			Global.tDisposeする( this.FPS );
			Global.tDisposeする( this.VPS );
			Global.tDisposeする( this.sdカーソル移動音 );
			Global.tDisposeする( this.sd曲決定音 );
			Global.tDisposeする( this.ms背景動画 );
			Global.tDisposeする( this.mスクロールアニメ用一定間隔処理 );

			base.On非活性化();
		}
		public override void Onリソースの作成( IntPtr hDevice )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			// 登録済みのサムネイルテクスチャを全て作成。

			int n総サムネイル数 = this.dicThumbnail.Count;
			string[] arr全画像の絶対パス = new string[ n総サムネイル数 ];
			this.dicThumbnail.Keys.CopyTo( arr全画像の絶対パス, 0 );
			foreach( var stg画像の絶対パス in arr全画像の絶対パス )
				this.dicThumbnail[ stg画像の絶対パス ] = this.tサムネイルテクスチャを作成する( hDevice, Path.GetDirectoryName( stg画像の絶対パス ) );


			// 登録済みのプロパティテクスチャを全て作成。

			n総サムネイル数 = this.dicProperty.Count;
			arr全画像の絶対パス = new string[ n総サムネイル数 ];
			this.dicProperty.Keys.CopyTo( arr全画像の絶対パス, 0 );
			foreach( var stg画像の絶対パス in arr全画像の絶対パス )
				this.dicProperty[ stg画像の絶対パス ] = this.tプロパティテクスチャを作成する( hDevice, stg画像の絶対パス );


			// その他を作成。

			this.txWhite = new CTexture( hDevice, Folder.stgテーマファイル( @"White 64x64.png" ) );
			this.txヘッダ = new CTexture( hDevice, Folder.stgテーマファイル( @"ScreenSelect header.png" ) );
			this.txブランク画像 = new CTexture( hDevice, Folder.stgテーマファイル( @"ScreenSelect blank image.png" ) );
			this.txSongNotFound = new CTexture( hDevice, Folder.stgテーマファイル( @"ScreenSelect song not found.png" ) );

			base.Onリソースの作成( hDevice );
		}
		public override void Onリソースの解放()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			foreach( var kvp in this.dicThumbnail )
				Global.tDisposeする( kvp.Value );

			foreach( var kvp in this.dicProperty )
				Global.tDisposeする( kvp.Value );

			Global.tDisposeする( this.txWhite );
			Global.tDisposeする( this.txヘッダ );
			Global.tDisposeする( this.txブランク画像 );
			Global.tDisposeする( this.txSongNotFound );

			base.Onリソースの解放();
		}
		public override int On進行()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return (int) E進行結果.継続;
			//-----------------
			#endregion


			// 進行。

			#region [ 初めての進行処理。]
			//-----------------
			if( this.b初めての進行 )
			{
				// 背景動画再生開始。

				if( this.ms背景動画 != null )
					this.ms背景動画.t再生する( 0 );

				// FPS/VPS 測定開始。

				this.FPS = new CFPS();
				this.VPS = new CFPS();

				// フェードイン開始

				this.Actホワイトイン.t開始();


				// 入力リセット

				Global.Input.Input管理.tポーリング( true, true );

				this.b初めての進行 = false;
			}
			//-----------------
			#endregion

			// 全フェーズ共通の進行。

			#region [ スクロールアニメの進行と曲番号マップの更新。]
			//-----------------
			if( this.list現在の曲リスト.Count > 0 )
			{
				// スクロールを進行。

				this.mスクロールアニメ用一定間隔処理.t進行( 5, () => {

					int n加速度 = 1;
					int n残距離 = Math.Abs( (int) ( this.n目標のスクロールカウンタ - this.n現在のスクロールカウンタ ) );

					#region [ 残距離が遠いほどスクロールを速くする（＝n加速度を多くする）。]
					//-----------------
					if( n残距離 <= 100 )
					{
						n加速度 = 4;
					}
					else if( n残距離 <= 300 )
					{
						n加速度 = 8;
					}
					else if( n残距離 <= 500 )
					{
						n加速度 = 12;
					}
					else
					{
						n加速度 = 16;
					}
					//-----------------
					#endregion

					#region [ 加速度を加算し、現在のスクロールカウンタを目標のスクロールカウンタまで近づける。 ]
					//-----------------
					if( this.n現在のスクロールカウンタ < this.n目標のスクロールカウンタ )		// (A) 正の方向に未達の場合：
					{
						this.n現在のスクロールカウンタ += n加速度;								// カウンタを正方向に移動する。

						if( this.n現在のスクロールカウンタ > this.n目標のスクロールカウンタ )
							this.n現在のスクロールカウンタ = this.n目標のスクロールカウンタ;	// 到着！スクロール停止！
					}
					else if( this.n現在のスクロールカウンタ > this.n目標のスクロールカウンタ )	// (B) 負の方向に未達の場合：
					{
						this.n現在のスクロールカウンタ -= n加速度;								// カウンタを負方向に移動する。

						if( this.n現在のスクロールカウンタ < this.n目標のスクロールカウンタ )	// 到着！スクロール停止！
							this.n現在のスクロールカウンタ = this.n目標のスクロールカウンタ;
					}
					//-----------------
					#endregion

					if( this.n現在のスクロールカウンタ >= 100 )		// １行＝100カウント。
					{
						#region [ 曲マトリックスを右から左へ１列シフトする。]
						//-----------------
						if( this.sdカーソル移動音 != null )
							this.sdカーソル移動音.t先頭から再生する();

						this.n現在の中心曲番号 = this.t中心曲から指定された相対数だけ離れた曲番号を返す( -3 );
						this.n現在の選択曲番号 = ( ( this.n現在の中心曲番号 + ( this.nカーソルY位置0to2 - 1 ) ) + this.list現在の曲リスト.Count ) % this.list現在の曲リスト.Count;

						this.n現在のスクロールカウンタ -= 100;
						this.n目標のスクロールカウンタ -= 100;

						//if( this.n目標のスクロールカウンタ == 0 )
						//	CDTXMania.stage選曲.t選択曲変更通知();		// スクロール完了＝選択曲変更！

						//-----------------
						#endregion
					}
					else if( this.n現在のスクロールカウンタ <= -100 )
					{
						#region [ 曲マトリックスを左から右へ１列シフトする。]
						//-----------------
						if( this.sdカーソル移動音 != null )
							this.sdカーソル移動音.t先頭から再生する();

						this.n現在の中心曲番号 = this.t中心曲から指定された相対数だけ離れた曲番号を返す( +3 );
						this.n現在の選択曲番号 = ( ( this.n現在の中心曲番号 + ( this.nカーソルY位置0to2 - 1 ) ) + this.list現在の曲リスト.Count ) % this.list現在の曲リスト.Count;

						this.n現在のスクロールカウンタ += 100;
						this.n目標のスクロールカウンタ += 100;

						//if( this.n目標のスクロールカウンタ == 0 )
						//	CDTXMania.stage選曲.t選択曲変更通知();		// スクロール完了＝選択曲変更！

						//-----------------
						#endregion
					}
				} );
			}

			// 毎回、最新の情報で更新。

			this.t現在の中心曲を起点として曲番号マップを更新する();
			//-----------------
			#endregion

			#region [ FPS 更新。]
			//-----------------
			if( this.FPS != null )
				this.FPS.tカウンタ更新();
			//-----------------
			#endregion

			// フェーズ別の進行。

			switch( this.eフェーズID.Get() )
			{
				case EフェーズID.フェードイン:
					#region [ 完了したら通常フェーズへ ]
					//-----------------
					if( this.Actホワイトイン.b完了 )
						this.eフェーズID.Set( EフェーズID.通常 );

					this.Actホワイトイン.On進行();	// 進行は完了チェックの後に！
					break;
					//-----------------
					#endregion

				case EフェーズID.曲リスト編集:
					#region [ 曲リスト編集が確定すればマトリックスを更新する。キャンセルされたら無視。]
					//-----------------
					switch( (E進行結果) this.Act曲リスト管理.On進行() )
					{ 
						case E進行結果.完了:
							this.t選択曲を最初の曲にリセットする();
							this.t現在の中心曲を起点として曲番号マップを更新する();
							this.eフェーズID.Set( EフェーズID.通常 );
							break;

						case E進行結果.キャンセル:
							this.eフェーズID.Set( EフェーズID.通常 );
							break;

						case E進行結果.継続:
							break;
					}
					break;
					//-----------------
					#endregion

				case EフェーズID.ユーザ変更:
					#region [ ユーザが変更されれば、ログアウトならびにログイン、マトリックスの更新を行う。]
					//-----------------
					switch( (E進行結果) this.Actログインユーザ選択.On進行() )
					{
						case E進行結果.完了:
							if( !string.IsNullOrEmpty( this.Actログインユーザ選択.stg選択されたユーザ名 ) )
							{
								Global.User.tログアウトする();
								Global.User.tログインする( this.Actログインユーザ選択.stg選択されたユーザ名 );
								this.t選択曲を最初の曲にリセットする();
								this.t現在の中心曲を起点として曲番号マップを更新する();
							}
							this.eフェーズID.Set( EフェーズID.通常 );
							break;

						case E進行結果.キャンセル:
							break;

						case E進行結果.継続:
							break;
					}
					break;
					//-----------------
					#endregion

				case EフェーズID.キーアサイン変更:
					#region [ キーアサインを実行し、ファイルに保存する。]
					//-----------------
					switch( (E進行結果) this.Act入力割当.On進行() )
					{
						case E進行結果.完了:
							this.eフェーズID.Set( EフェーズID.通常 );
							break;
					}
					break;
					//-----------------
					#endregion
			
				case EフェーズID.設定:
					#region [ コンフィグ画面を表示し、ファイルに保存する。]
					//-----------------
					switch( (E進行結果) this.Actコンフィグ.On進行() )
					{
						case E進行結果.完了:
							this.eフェーズID.Set( EフェーズID.通常 );
							break;
					}
					break;
					//-----------------
					#endregion
			}


			// 入力。

			#region [ ESC → 終了 ]
			//-----------------
			if( Global.Input.Input管理.Keyboard.bキーが押された( Key.Escape ) )
				return (int) E進行結果.キャンセル;
			//-----------------
			#endregion


			#region [ F1 → ユーザ別設定ウィンドウ起動 ]
			//-----------------
			if( Global.Input.Input管理.Keyboard.bキーが押された( Key.F1 ) )
			{
				this.Actコンフィグ.tリセット();
				this.eフェーズID.Set( EフェーズID.設定 );
			}
			//-----------------
			#endregion
			#region [ F2 → ユーザ別曲管理フェーズへ ]
			//-----------------
			if( Global.Input.Input管理.Keyboard.bキーが押された( Key.F2 ) )
			{
				this.Act曲リスト管理.tリセット();
				this.eフェーズID.Set( EフェーズID.曲リスト編集 );
			}
			//-----------------
			#endregion
			#region [ F3 → 入力割り当てウィンドウ起動 ]
			//-----------------
			if( Global.Input.Input管理.Keyboard.bキーが押された( Key.F3 ) )
			{
				this.Act入力割当.tリセット();
				this.eフェーズID.Set( EフェーズID.キーアサイン変更 );
			}
			//-----------------
			#endregion
			#region [ F12 → ユーザ変更フェーズへ ]
			//-----------------
			if( Global.Input.Input管理.Keyboard.bキーが押された( Key.F12 ) )
			{
				this.Actログインユーザ選択.tリセット();
				this.eフェーズID.Set( EフェーズID.ユーザ変更 );
			}
			//-----------------
			#endregion


			// 以下のキーは、曲が１曲以上ある場合のみ有効。

			if( this.list現在の曲リスト.Count > 0 )
			{
				#region [ Enter, シンバル類 → 曲決定 ]
				//-----------------
				if( Global.Input.Input管理.Keyboard.bキーが押された( Key.Return ) ||
					Global.Input.bシンバル類のいずれかが押された )
				{
					if( this.sd曲決定音 != null )
						this.sd曲決定音.t先頭から再生する();

					if( this.ms背景動画 != null )
						this.ms背景動画.t停止する();

					Global.Song.r現在演奏中の曲 = Global.Song.list曲リスト[ this.n現在の選択曲番号 ];

					return (int) E進行結果.曲決定;
				}
				//-----------------
				#endregion
				#region [ 右矢印, FT → 曲マトリックスを右へスクロール ]
				//-----------------
				if( Global.Input.Input管理.Keyboard.bキーが押された( Key.RightArrow ) ||
					Global.Input.bフロアタム類のいずれかが押された )
				{
					// 最小でも-800まで。（連打をやめると、慣性で最大8列スクロールして停止する。）
					this.n目標のスクロールカウンタ = Math.Max( this.n目標のスクロールカウンタ - 100, -800 );
				}
				//-----------------
				#endregion
				#region [ 左矢印, SD → 曲マトリックスを左へスクロール ]
				//-----------------
				if( Global.Input.Input管理.Keyboard.bキーが押された( Key.LeftArrow ) ||
					Global.Input.bスネア類のいずれかが押された )
				{
					// 最大でも+800まで。（連打をやめると、慣性で最大8列スクロールして停止する。）
					this.n目標のスクロールカウンタ = Math.Min( this.n目標のスクロールカウンタ + 100, 800 );
				}
				//-----------------
				#endregion
				#region [ 上矢印, HT → 曲カーソルを上に移動。]
				//-----------------
				if( Global.Input.Input管理.Keyboard.bキーが押された( Key.UpArrow ) ||
					Global.Input.bハイタム類のいずれかが押された )
				{
					if( this.nカーソルY位置0to2 > 0 )
					{
						if( this.sdカーソル移動音 != null )
							this.sdカーソル移動音.t先頭から再生する();

						this.nカーソルY位置0to2--;
						this.n現在の選択曲番号 = ( ( this.n現在の選択曲番号 - 1 ) + this.list現在の曲リスト.Count ) % this.list現在の曲リスト.Count;
					}
					else
					{
						this.nカーソルY位置0to2 = 2;

						// 最大でも+800まで。（連打をやめると、慣性で最大8列スクロールして停止する。）
						this.n目標のスクロールカウンタ = Math.Min( this.n目標のスクロールカウンタ + 100, 800 );
					}
				}
				//-----------------
				#endregion
				#region [ 下矢印, LT → 曲カーソルを下に移動。]
				//-----------------
				if( Global.Input.Input管理.Keyboard.bキーが押された( Key.DownArrow ) ||
					Global.Input.bロータム類のいずれかが押された )
				{
					if( this.nカーソルY位置0to2 < 2 )
					{
						if( this.sdカーソル移動音 != null )
							this.sdカーソル移動音.t先頭から再生する();

						this.nカーソルY位置0to2++;
						this.n現在の選択曲番号 = ( this.n現在の選択曲番号 + 1 ) % this.list現在の曲リスト.Count;
					}
					else
					{
						this.nカーソルY位置0to2 = 0;

						// 最小でも-800まで。（連打をやめると、慣性で最大8列スクロールして停止する。）
						this.n目標のスクロールカウンタ = Math.Max( this.n目標のスクロールカウンタ - 100, -800 );
					}
				}
				//-----------------
				#endregion
			}

			return (int) E進行結果.継続;
		}
		public override void On描画前()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			switch( this.eフェーズID.Get() )
			{
				case EフェーズID.曲リスト編集:
					this.Act曲リスト管理.On描画前();
					break;

				case EフェーズID.ユーザ変更:
					this.Actログインユーザ選択.On描画前();
					break;

				case EフェーズID.キーアサイン変更:
					this.Act入力割当.On描画前();
					break;

				case EフェーズID.設定:
					this.Actコンフィグ.On描画前();
					break;
			}
		}
		public override void On描画( IntPtr hDevice )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			#region [ 背景動画 ]
			//-----------------
			if( this.ms背景動画 != null )
				this.ms背景動画.t最新のサンプルを描画する();
			//-----------------
			#endregion

			if( this.list現在の曲リスト.Count == 0 )
			{
				// (A) 曲がないなら Song not found を表示する。

				#region [ 背景のブランク枠を表示。]
				//-----------------
				if( this.txブランク画像 != null )
				{
					for( int i = 0; i < 9 * 3; i++ )
					{
						int x = i / 3;
						int y = i % 3;
						var mat = Matrix.Identity;
						mat *= Matrix.RotationY( this.stマトリックス座標[ x, y ].rotY );
						mat *= Matrix.Translation(
							this.stマトリックス座標[ x, y ].x,
							this.stマトリックス座標[ x, y ].y,
							this.stマトリックス座標[ x, y ].z );
						this.txブランク画像.t3D描画( hDevice, mat );
					}
				}
				//-----------------
				#endregion
				#region [ Song not found テクスチャを表示。]
				//-----------------
				if( this.txSongNotFound != null )
				{
					this.txSongNotFound.t2D描画(
						hDevice,
						Theme.szウィンドウ.Width / 2 - this.txSongNotFound.sz画像サイズ.Width / 2,
						Theme.szウィンドウ.Height / 2 - this.txSongNotFound.sz画像サイズ.Height / 2 - 40 );	// -40 は背景に合わせた調整値。
				}
				//-----------------
				#endregion
			}
			else
			{
				// (B) 曲があるならサムネイルマトリックスを描画する。

				#region [ 曲マトリックス；ar曲番号マップ[,] に従って描画する。]
				//-----------------
				for( int i = 0; i < 9 * 3 + 1; i++ )
				{
					int mx = i / 3;
					int my = i % 3;

					if( ( mx == 0 && this.n現在のスクロールカウンタ < 0 ) ||	// 最左列は、左に移動中なら表示しない。
						( mx == 8 && this.n現在のスクロールカウンタ > 0 ) )		// 最右列は、右に移動中なら表示しない。
						continue;

					#region [ 選択パネルは一番最後に表示する。]
					//-----------------
					if( mx == 4 && my == this.nカーソルY位置0to2 )		// 選択パネルは描画せずにスキップし、一番最後に回す。
						continue;

					if( i == 9 * 3 + 1 - 1 )			// 一番最後。
					{
						mx = 4;							// Xは常に中央
						my = this.nカーソルY位置0to2;	//
					}
					//-----------------
					#endregion

					var song = this.list現在の曲リスト[ this.ar曲番号マップ[ mx, my ] ];

					int dx = ( this.n現在のスクロールカウンタ == 0 ) ? 0 : ( ( this.n現在のスクロールカウンタ < 0 ) ? -1 : +1 );
					float f割合 = Math.Abs( this.n現在のスクロールカウンタ ) / 100.0f;

					#region [ サムネイルを描画。]
					//-----------------
					CTexture txTumbnail = null;

					#region [ サムネイルがないなら作成する。]
					//-----------------
					if( !this.dicThumbnail.ContainsKey( song.ScoreFile ) )
					{
						txTumbnail = this.tサムネイルテクスチャを作成する( hDevice, Path.GetDirectoryName( song.ScoreFile ) );
						this.dicThumbnail.Add( song.ScoreFile, txTumbnail );
					}
					//-----------------
					#endregion

					txTumbnail = this.dicThumbnail[ song.ScoreFile ];
					if( txTumbnail != null )
					{
						float f拡大率 = this.t曲が選択されている( mx, my ) ? 1.25f : 1.0f;
						var mat = Matrix.Identity;
						mat *= Matrix.Scaling( f拡大率, f拡大率, 1.0f );
						mat *= Matrix.RotationY( this.stマトリックス座標[ mx, my ].rotY + ( this.stマトリックス座標[ mx + dx, my ].rotY - this.stマトリックス座標[ mx, my ].rotY ) * f割合 );
						mat *= Matrix.Translation(
							( this.stマトリックス座標[ mx, my ].x + (int) ( ( this.stマトリックス座標[ mx + dx, my ].x - this.stマトリックス座標[ mx, my ].x ) * f割合 ) ),
							( this.stマトリックス座標[ mx, my ].y + (int) ( ( this.stマトリックス座標[ mx + dx, my ].y - this.stマトリックス座標[ mx, my ].y ) * f割合 ) ),
							( this.stマトリックス座標[ mx, my ].z + (int) ( ( this.stマトリックス座標[ mx + dx, my ].z - this.stマトリックス座標[ mx, my ].z ) * f割合 ) ) );
						txTumbnail.t3D描画( hDevice, mat );
					}
					//-----------------
					#endregion

					#region [ プロパティを描画。]
					//-----------------
					CTexture txProperty = null;

					#region [ プロパティがないなら作成する。]
					//-----------------
					if( !this.dicProperty.ContainsKey( song.ScoreFile ) )
					{
						txProperty = this.tプロパティテクスチャを作成する( hDevice, song.ScoreFile );
						this.dicProperty.Add( song.ScoreFile, txProperty );
					}
					//-----------------
					#endregion

					txProperty = this.dicProperty[ song.ScoreFile ];
					if( txProperty != null )
					{
						var mat = Matrix.Identity;
						mat *= Matrix.RotationY( this.stマトリックス座標[ mx, my ].rotY + ( this.stマトリックス座標[ mx + dx, my ].rotY - this.stマトリックス座標[ mx, my ].rotY ) * f割合 );
						int nサムネイルとの距離 = 8 + ( this.t曲が選択されている( mx, my ) ? 4 : 0 );
						mat *= Matrix.Translation(
							( this.stマトリックス座標[ mx, my ].x + (int) ( ( this.stマトリックス座標[ mx + dx, my ].x - this.stマトリックス座標[ mx, my ].x ) * f割合 ) ),
							( this.stマトリックス座標[ mx, my ].y + (int) ( ( this.stマトリックス座標[ mx + dx, my ].y - this.stマトリックス座標[ mx, my ].y ) * f割合 )
								- Theme.選曲.szサムネイルパネル.Height / 2 - Theme.選曲.szサムネイルプロパティパネル.Height / 2 - nサムネイルとの距離 ),
							( this.stマトリックス座標[ mx, my ].z + (int) ( ( this.stマトリックス座標[ mx + dx, my ].z - this.stマトリックス座標[ mx, my ].z ) * f割合 ) ) );
						txProperty.t3D描画( hDevice, mat );
					}
					//-----------------
					#endregion
				}
				//-----------------
				#endregion
			}

			#region [ 操作メモ；超簡単な操作メモを下部に表示。]
			//-----------------
			this.Act英数字描画.t表示( hDevice, 16, Theme.szウィンドウ.Height - 32, CAct英数字描画.E種別.白,
				"F1:Settings, F2:SongList, F3:AssignDrums, F12:ChangeUser" );
			this.Act英数字描画.t表示( hDevice, 16, Theme.szウィンドウ.Height - 32 - 16, CAct英数字描画.E種別.白,
				"Cursor: MoveCursor, Enter:DecideSong, ESC:Exit" );
			//-----------------
			#endregion
			#region [ FPS(VPS) ]
			//-----------------
			if( this.VPS != null )	// 曲が再生されるまでは、この描画メソッドは呼ばれるが VPS は生成されていない。
				this.VPS.tカウンタ更新();

			if( this.FPS != null && this.VPS != null )
			{
				string msg = string.Format( "FPS(VPS): {0}({1})", this.FPS.n現在のFPS, this.VPS.n現在のFPS );
				int n幅 = msg.Length * 8;
				this.Act英数字描画.t表示( hDevice, Theme.szウィンドウ.Width - n幅, Theme.szウィンドウ.Height - 16, CAct英数字描画.E種別.白太, msg );
			}
			//-----------------
			#endregion
			#region [ ヘッダ表示 ]
			//-----------------
			if( this.txヘッダ != null )
				this.txヘッダ.t2D描画( hDevice, 0, 0 );
			//-----------------
			#endregion

			switch( this.eフェーズID.Get() )
			{
				case EフェーズID.フェードイン:
					this.Actホワイトイン.On描画( hDevice, this.txWhite, Global.App.Direct3D );
					break;
			}
		}

		/// <summary>
		/// <para>現在選択中のSongが含まれるSongリスト。</para>
		/// <para>初期値はツリールート。BOXを出たり入ったりするたび更新される。</para>
		/// </summary>
		volatile List<SongNode> list現在の曲リスト = null;

		/// <summary>
		/// <para>現在選択されているSong番号。</para>
		/// <para>この番号は、C選曲ステージ.list現在の曲リスト[] のインデックスを示す。</para>
		/// </summary>
		int n現在の選択曲番号
		{
			get
			{
				if( this.stackBOXの曲番号 == null ||
					this.stackBOXの曲番号.Count == 0 )
				{
					throw new InvalidOperationException( "stackBOXの曲番号 が null または中身が空です。" );
				}

				return this.stackBOXの曲番号.Peek();
			}
			set
			{
				if( this.stackBOXの曲番号 == null )
					throw new NullReferenceException( "stackBOXの曲番号 が null です。" );


				// 先頭要素を置換。

				if( this.stackBOXの曲番号.Count > 0 )	// 先頭要素があれば除去。
					this.stackBOXの曲番号.Pop();

				this.stackBOXの曲番号.Push( value );	// 新しい要素を格納。
			}
		}

		volatile CFPS FPS;
		volatile CFPS VPS;
		volatile CSound sdカーソル移動音 = null;
		volatile CSound sd曲決定音 = null;
		volatile CMediaSession ms背景動画 = null;
		CMActフェードイン・透明度 Actホワイトイン;
		CAct英数字描画 Act英数字描画;
		CActユーザ別曲リスト管理 Act曲リスト管理;
		CActユーザ選択 Actログインユーザ選択;
		CAct入力割当 Act入力割当;
		CActコンフィグ Actコンフィグ;

		CTexture txWhite;
		CTexture txヘッダ;
		CTexture txブランク画像 = null;
		CTexture txSongNotFound = null;
		int nカーソルY位置0to2;
		int n現在のスクロールカウンタ;
		int n目標のスクロールカウンタ;
		C一定間隔処理 mスクロールアニメ用一定間隔処理;

		/// <summary>
		/// <para>3行7列（[9,3]）の曲番号の配列。</para>
		/// <para>△□□□□□□□△　　０が中心曲。（≠選択曲の場合あり）</para>
		/// <para>△□□□□□□□△　　■が選択曲。（≠中心曲の場合あり）</para>
		/// <para>△□□□■□□□△　　△は画面外。</para>
		/// </summary>
		int[ , ] ar曲番号マップ = new int[ 9, 3 ];

		/// <summary>
		/// <para>曲リスト（マトリックス）表示のための基準点。</para>
		/// </summary>
		int n現在の中心曲番号 = 0;

		/// <summary>
		/// <para>SSTFファイル絶対パス(key)とサムネイル画像(value)との辞書。</para>
		/// <para>アプリの起動から終了まで単純に増加を続け、要素が減ることはない。</para>
		/// </summary>
		Dictionary<string, CTexture> dicThumbnail = new Dictionary<string, CTexture>();

		/// <summary>
		/// <para>SSTFファイル絶対パス(key)とプロパティ画像(value)との辞書。</para>
		/// <para>アプリの起動から終了まで単純に増加を続け、要素が減ることはない。</para>
		/// </summary>
		Dictionary<string, CTexture> dicProperty = new Dictionary<string, CTexture>();

		struct ST中心点
		{
			public float x;
			public float y;
			public float z;
			public float rotY;
		}
		readonly ST中心点[ , ] stマトリックス座標 = new ST中心点[ 9, 3 ] {
			#region [ 実は円弧配置になってない ]
			//-----------------
			{ new ST中心点() { x = -533.8936f, y = 210f, z = -289.5575f, rotY = -0.9279888f },
				new ST中心点() { x = -533.8936f, y = 50f, z = -289.5575f, rotY = -0.9279888f },
				new ST中心点() { x = -533.8936f, y = -110f, z = -289.5575f, rotY = -0.9279888f } },
			{ new ST中心点() { x = -423.8936f, y = 210f, z = -169.5575f, rotY = -0.6579891f },
				new ST中心点() { x = -423.8936f, y = 50f, z = -169.5575f, rotY = -0.6579891f },
				new ST中心点() { x = -423.8936f, y = -110f, z = -169.5575f, rotY = -0.6579891f } },
			{ new ST中心点() { x = -297.5025f, y = 210f, z = -74.37564f, rotY = -0.4808382f },
				new ST中心点() { x = -297.5025f, y = 50f, z = -74.37564f, rotY = -0.4808382f },
				new ST中心点() { x = -297.5025f, y = -110f, z = -74.37564f, rotY = -0.4808382f } },
			{ new ST中心点() { x = -153.9001f, y = 210f, z = -20.52002f, rotY = -0.2605f },
				new ST中心点() { x = -153.9001f, y = 50f, z = -20.52002f, rotY = -0.2605f },
				new ST中心点() { x = -153.9001f, y = -110f, z = -20.52002f, rotY = -0.2605f } },
			{ new ST中心点() { x = 0.00002622683f, y = 210f, z = 0f, rotY = 0f }, 
				new ST中心点() { x = 0.00002622683f, y = 50f, z = 0f, rotY = 0f }, 
				new ST中心点() { x = 0.00002622683f, y = -110f, z = 0f, rotY = 0f } },
			{ new ST中心点() { x = 153.9002f, y = 210f, z = -20.52002f, rotY = 0.2605f },
				new ST中心点() { x = 153.9002f, y = 50f, z = -20.52002f, rotY = 0.2605f },
				new ST中心点() { x = 153.9002f, y = -110f, z = -20.52002f, rotY = 0.2605f } },
			{ new ST中心点() { x = 297.5025f, y = 210f, z = -74.37564f, rotY = 0.4808382f },
				new ST中心点() { x = 297.5025f, y = 50f, z = -74.37564f, rotY = 0.4808382f },
				new ST中心点() { x = 297.5025f, y = -110f, z = -74.37564f, rotY = 0.4808382f } },
			{ new ST中心点() { x = 423.8936f, y = 210f, z = -169.5575f, rotY = 0.6579891f },
				new ST中心点() { x = 423.8936f, y = 50f, z = -169.5575f, rotY = 0.6579891f },
				new ST中心点() { x = 423.8936f, y = -110f, z = -169.5575f, rotY = 0.6579891f } },
			{ new ST中心点() { x = 533.8936f, y = 210f, z = -289.5575f, rotY = 0.9279888f },
				new ST中心点() { x = 533.8936f, y = 50f, z = -289.5575f, rotY = 0.9279888f },
				new ST中心点() { x = 533.8936f, y = -110f, z = -289.5575f, rotY = 0.9279888f } },
			//-----------------
			#endregion
		};

		int t中心曲から指定された相対数だけ離れた曲番号を返す( int n相対数 )
		{
			int n曲番号 = this.n現在の中心曲番号 + n相対数;
			int n曲数 = this.list現在の曲リスト.Count;

			// リストは、正方向にも負方向にも循環する。

			while( n曲番号 < 0 )
				n曲番号 += n曲数;

			return n曲番号 % n曲数;
		}

		CTexture tサムネイルテクスチャを作成する( IntPtr hLockedDevice, string strフォルダパス )
		{
			CTexture txThumnail = null;

			string[] files = Directory.GetFiles( strフォルダパス, "thumb.*" );
			foreach( var file in files )
			{
				string ext = Path.GetExtension( file ).ToLower();

				if( ext.Equals( ".jpg" ) || ext.Equals( ".jpeg" ) ||	// 片っ端から放り込んでログが例外の山になるものウザイし、
					ext.Equals( ".png" ) ||								// とりあえず対応拡張子はこれだけにしておく。
					ext.Equals( ".bmp" ) )
				{
					const int n縁の幅px = 6;
					using( var bmpFromfile = new Bitmap( file ) )
					using( var bmp = new Bitmap( Theme.選曲.szサムネイルパネル.Width + n縁の幅px * 2, Theme.選曲.szサムネイルパネル.Height + n縁の幅px * 2 ) )
					using( var g = Graphics.FromImage( bmp ) )
					{
						g.FillRectangle( Brushes.Black, 0, 0, bmp.Width, bmp.Height );

						#region [ bmpFromFile を、bmp 内部に収まり、センタリングされる位置に描画する。小さい画像は拡大し、大きい画像は縮小する。]
						//-----------------
						int w = bmpFromfile.Width;
						int h = bmpFromfile.Height;

						if( w > h )
						{
							h = (int) ( h * (double) ( bmp.Width - n縁の幅px * 2 ) / (double) w );
							w = bmp.Width - n縁の幅px * 2;
						}
						else
						{
							w = (int) ( w * (double) ( bmp.Height - n縁の幅px * 2 ) / (double) h );
							h = bmp.Height - n縁の幅px * 2;
						}
						int x = ( bmp.Width - w ) / 2;
						int y = ( bmp.Height - h ) / 2;

						g.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.Bicubic;
						g.DrawImage( bmpFromfile, new Rectangle( x, y, w, h ) );
						//-----------------
						#endregion
						#region [ 画像を縁取る。]
						//-----------------
						g.FillRectangle( Brushes.White, new Rectangle( 0, 0, n縁の幅px, bmp.Height ) );
						g.FillRectangle( Brushes.White, new Rectangle( bmp.Width - n縁の幅px, 0, n縁の幅px, bmp.Height ) );
						g.FillRectangle( Brushes.White, new Rectangle( 0, 0, bmp.Width, n縁の幅px ) );
						g.FillRectangle( Brushes.White, new Rectangle( 0, bmp.Height - n縁の幅px, bmp.Width, bmp.Height ) );
						int n幅 = n縁の幅px / 2;
						g.FillRectangle( Brushes.Black, new Rectangle( 0, 0, n幅, bmp.Height ) );
						g.FillRectangle( Brushes.Black, new Rectangle( bmp.Width - n幅, 0, n幅, bmp.Height ) );
						g.FillRectangle( Brushes.Black, new Rectangle( 0, 0, bmp.Width, n幅 ) );
						g.FillRectangle( Brushes.Black, new Rectangle( 0, bmp.Height - n幅, bmp.Width, bmp.Height ) );
						//-----------------
						#endregion

						txThumnail = new CTexture( hLockedDevice, bmp );
					}
					return txThumnail;
				}
			}

			// サムネイルがないのでデフォルト画像を返す。

			txThumnail = new CTexture( hLockedDevice, Folder.stgテーマファイル( @"ScreenSelect no image.png" ) );
			return txThumnail;
		}
		CTexture tプロパティテクスチャを作成する( IntPtr hLockedDevice, string str曲ファイルパス )
		{
			// スコアのヘッダを読み込む。

			var score = new Cスコア();
			try
			{
				score.t曲データファイルを読み込む・ヘッダだけ( str曲ファイルパス );
			}
			catch
			{
				#region [ 読み込み失敗 → 空のテクスチャを返す。]
				//-----------------
				CTexture txBlank = null;
				using( var bmp = new Bitmap( Theme.選曲.szサムネイルプロパティパネル.Width, Theme.選曲.szサムネイルプロパティパネル.Height ) )
				{
					txBlank = new CTexture( hLockedDevice, bmp );
				}
				return txBlank;
				//-----------------
				#endregion
			}


			// プロパティテクスチャを作成。

			CTexture txProperty = null;

			using( var bmp = new Bitmap( Theme.選曲.szサムネイルプロパティパネル.Width, Theme.選曲.szサムネイルプロパティパネル.Height ) )
			using( var g = Graphics.FromImage( bmp ) )
			using( var font = new Font( FontFamily.GenericSerif, 12.0f ) )
			using( var format = new StringFormat() { Alignment = StringAlignment.Center } )
			using( var br背景 = new System.Drawing.Drawing2D.LinearGradientBrush(
				g.VisibleClipBounds,
				Color.FromArgb( 255, 255, 144, 0 ),	// 上
				Color.FromArgb( 0, 0, 0, 0 ),		// 下
				System.Drawing.Drawing2D.LinearGradientMode.Vertical ) )
			using( var br文字本体 = new SolidBrush( Color.Black ) )
			using( var br文字縁 = new SolidBrush( Color.White ) )
			using( var pen = new Pen( br文字縁, 5.0f ) )
			using( var path = new System.Drawing.Drawing2D.GraphicsPath() )
			{
				var rc = new RectangleF( 0f, 0f, (float) bmp.Width, (float) bmp.Height );

				g.FillRectangle( br背景, rc );
				g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.HighQuality;

				rc.Y += 4;			// 4 はマージン
				rc.Height -= 4;		//
				path.AddString( score.Header.str曲名, font.FontFamily, (int) font.Style, font.Size, rc, format );
				g.DrawPath( pen, path );
				g.FillPath( br文字本体, path );

				txProperty = new CTexture( hLockedDevice, bmp );
			}

			return txProperty;
		}
		
		/// <summary>
		/// <para>BOXに入ったときの Global.Song.list曲リスト の曲番号（配列のインデックス）を階層的に記憶しておくための LIFO 。</para>
		/// <para>BOXに入るたびその BOX の曲番号を Push し、BOX から出るたび親 BOX の曲番号を Pop する。</para>
		/// <para>最初に Push されるのは、ツリールートの先頭曲番号(=0)。</para>
		/// <para>このスタックは基本的に C演奏ステージ.n現在の選択曲番号 プロパティで制御するため、private に置いておく。</para>
		/// </summary>
		Stack<int> stackBOXの曲番号 = null;

		bool t曲が選択されている( int mx0to8, int my0to2 )
		{
			return ( mx0to8 == 4 && my0to2 == this.nカーソルY位置0to2 );
		}
	}
}
